use "$directory/Gallup World Poll/Gallup_macro", clear
gen gdp=exp(lgdp)/1000
replace lgdp=ln(gdp)

* Number of countries
tab cty
di("`r(N)' countries in this dataset")
tab cty if lgdp==.
tab cty if lgdp~=. & sat_current~=.
di("`r(N)' countries have valid satisfaction ladder and gdp data")
tab cty if sat_life~=. & lgdp~=.
di("`r(N)' countries have valid life satisfaction and gdp data")

reg sat_current_z lgdp
correl sat_current_z lgdp

*** Figure 0: Showing the results on a non-log scale

local sd : char sat_current_z[sd]
local mean : char sat_current_z[mean]
local ylab ""
foreach i of num 2/9 {
	local yl=(`i'-`mean')/`sd'
	local ylab "`ylab' `yl' " `i' ""
}

#delimit ;
	twoway
		(scatter sat_current_z gdp , mlabel(cty) mcolor(navy) mlabcolor(navy) yaxis(1 2)) 
	,
		xlabel(0(10)80) 
		xtitle("GDP per capita at PPP ($000s)")
		ylabel(`ylab', angle(horizontal) format(%9.0f))
		ytick(-1.7 1.7, notick)
		ytitle("Satisfaction Ladder (0-10 scale)")
		ylabel(-1.5(.5)1.5 , axis(2) angle(horizontal) format(%9.1f))
		ytitle("Satisfaction Ladder (normalized scale)", axis(2))
		title("Satisfaction Ladder", ring(0) span)
			subtitle(" " "(Gallup World Poll, 2008-2012)", ring(0))
		legend(off)
		xsize(10) ysize(7.5)
		name(Gallup_nolog, replace)
	;
#delimit cr;

*** Figure 1
gen rich=(gdp>=15) if !missing(gdp)
gen rich_lgdp=rich*(lgdp-ln(15))
gen poor_lgdp=(1-rich)*(lgdp-ln(15))
la var sat_current_z "Satisfaction Ladder"
la var sat_life_z "Life Satisfaction"

foreach v of varlist sat_current_z sat_life_z {
	summ gdp if !missing(`v')
	local gdpmin=`r(min)'
	local gdpmax=`r(max)'
	local title: variable label `v'
	reg `v' lgdp, robust
	predict `v'_hat_fit if `v'~=.
	summ lgdp if `v'~=., det
	gen top_lgdp=(lgdp>=r(p50))*(lgdp-r(p50))
	gen bottom_lgdp=(lgdp<r(p50))*(lgdp-r(p50))
	reg `v' top_lgdp bottom_lgdp, robust
	predict `v'_hat_fit2 if `v'~=.
	local b_top=string(_b[top_lgdp],"%3.2f")
	local se_top=string(_se[top_lgdp],"%3.2f")
	local b_bottom=string(_b[bottom_lgdp],"%3.2f")
	local se_bottom=string(_se[bottom_lgdp], "%3.2f")
	reg `v' rich_lgdp poor_lgdp , robust
	predict `v'_hat_fit3 if `v'~=.
	local b_rich=string(_b[rich_lgdp], "%3.2f")
	local se_rich=string(_se[rich_lgdp], "%3.2f")
	local b_poor=string(_b[poor_lgdp], "%3.2f")
	local se_poor=string(_se[poor_lgdp], "%3.2f")
	lowess `v' lgdp , nograph generate(`v'_hat_low)
	local sd : char `v'[sd]
	local mean : char `v'[mean]
	local ylab ""
	foreach i of num 2/9 {
		local yl=(`i'-`mean')/`sd'
		local ylab "`ylab' `yl' " `i' ""
	}
	#delimit ;
	twoway
		(scatter `v' gdp , mlabel(cty) mcolor(navy) mlabcolor(navy) yaxis(1 2)) 
		(line `v'_hat_low gdp , sort lpattern(dot) lcolor(cranberry) lwidth(thick)) 
		(line `v'_hat_fit gdp , sort lpattern(solid) lcolor(black) yaxis(1) lwidth(thin)) 
/*		(line `v'_hat_fit2 gdp , sort lpattern(shortdash) lcolor(purple) lwidth(thick)) */
		(line `v'_hat_fit3 gdp , sort lpattern(longdash) lcolor(green) lwidth(thick))
	,
		xscale(log)
		xlabel(.25 .5 1 2 4 8 16 32 64) 
		xtitle("GDP per capita at PPP ($000s, log scale)")
		ylabel(`ylab', angle(horizontal) format(%9.0f))
		ytick(-1.7 1.7, notick)
		ytitle("`title' (0-10 scale)")
		ylabel(-1.5(.5)1.5 , axis(2) angle(horizontal) format(%9.1f))
		ytitle("`title' (normalized scale)", axis(2))
		title("`title'", ring(0) span)
		subtitle(" " "(Gallup World Poll, 2008-2012)", ring(0))
		legend(off)
/*		text(-1.60 `gdpmax' "Rich half: Slope=`b_top' (`se_top')", justification(right) placement(9) size(small) color(purple))
		text(-1.60 `gdpmin' "Poor half: Slope=`b_bottom' (`se_bottom')", justification(right) placement(3) size(small) color(purple))
*/		text(-1.74 `gdpmax' "GDP>$15k: Slope=`b_rich' (`se_rich')", justification(right) placement(9) size(small) color(green))
		text(-1.74 `gdpmin' "GDP<$15k: Slope=`b_poor' (`se_poor')", justification(right) placement(3) size(small) color(green))
		xsize(10) ysize(7.5)
		name(Gallup_`v', replace)
	;
	#delimit cr	
	graph export "$directory/Charts/fig1_`v'.eps", replace
	graph save "$directory/Charts/fig1_`v'.gph", replace
	drop `v'_hat_fi* `v'_hat_low top_lgdp bottom_lgdp
}

* Table 1
for X in num 8 15 25: ///
	gen richX=(gdp>X) if !missing(gdp) \ ///
	gen richX_lgdp=richX*(lgdp-ln(X)) \ ///
	gen poorX_lgdp=(1-richX)*(lgdp-ln(X)) 

reg lgdp lgdp
outreg2 using "$directory/Gallup World Poll/Table1_Gallup", replace ctitle("Ignore")
foreach v of varlist sat_current_z sat_life_z {
		for X in num 8 15 25 :  ///
			reg `v' richX_lgdp poorX_lgdp , robust \ ///
			lincom richX_lgdp-poorX_lgdp \ ///
			outreg2 using "$directory/Gallup World Poll/Table1_Gallup",  append ctitle(`v'_`w'_Xk) addstat(Diff, r(estimate), SE, r(se), p_val, 2*(1-normal(abs(r(estimate)/r(se)))))
		
		summ lgdp if `v'~=. , det
		gen top_lgdp=(lgdp>=r(p50))*(lgdp-r(p50))
		gen bottom_lgdp=(lgdp<r(p50))*(lgdp-r(p50))
		reg `v' top_lgdp bottom_lgdp, robust
		lincom top_lgdp-bottom_lgdp	
		outreg2 using "$directory/Gallup World Poll/Table1_Gallup",  append ctitle(`v'_`w'_>med) addstat(Diff, `r(estimate)', SE, `r(se)', p_val, 2*(1-normal(abs(`r(estimate)'/`r(se)'))))

		drop top_lgdp bottom_lgdp
}

